﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.IO

Public Class Form1

    Dim TekstZmieniony As Boolean = False

    Private Sub ZamknijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZamknijToolStripMenuItem.Click
        'Close()
        Application.Exit()
    End Sub

    Private Sub Form1_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If Not TekstZmieniony Then Return
        Dim dr As DialogResult = MessageBox.Show("Czy zapisać zmiany w edytowanym dokumencie?", Me.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3)
        Select Case dr
            Case DialogResult.Yes
                'MessageBox.Show("Wstawić wywołanie metody zapisującej zawartość notatnika do pliku")
                ZapiszJakoToolStripMenuItem_Click(Nothing, Nothing)
            Case DialogResult.No
            Case DialogResult.Cancel
                e.Cancel = True
            Case Else
                e.Cancel = True
        End Select
    End Sub

    Private Sub TextBox1_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBox1.TextChanged
        TekstZmieniony = True
    End Sub

    Private Sub PasekstanuToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles PasekstanuToolStripMenuItem.Click
        PasekstanuToolStripMenuItem.Checked = Not PasekstanuToolStripMenuItem.Checked
        StatusStrip1.Visible = PasekstanuToolStripMenuItem.Checked
    End Sub

    Public Shared Function CzytajPlikTekstowy(nazwaPliku As String) As String()
        Dim tekst As List(Of String) = New List(Of String)
        Try
            Using sr As StreamReader = New StreamReader(nazwaPliku)
                Dim wiersz As String = sr.ReadLine()
                While Not wiersz Is Nothing
                    tekst.Add(wiersz)
                    wiersz = sr.ReadLine()
                End While
                sr.Close()
                Return tekst.ToArray()
            End Using
        Catch e As Exception
            'MessageBox.Show("Błąd odczytu pliku " & nazwaPliku & " (" & e.Message & ")")

            MessageBox.Show(
                "Błąd odczytu pliku " & nazwaPliku & vbNewLine & "Opis wyjątku: " & e.Message,
                "Notatnik.NET - Błąd przy wczytywaniu pliku",
                MessageBoxButtons.OK,
                MessageBoxIcon.Error)

            Return Nothing
        End Try
    End Function

    Private Sub OtwórzToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles OtwórzToolStripMenuItem.Click
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            Dim nazwaPliku As String = OpenFileDialog1.FileName
            TextBox1.Lines = CzytajPlikTekstowy(nazwaPliku)
            Dim ostatniSlash As Integer = nazwaPliku.LastIndexOf("\")
            ToolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1)
            TekstZmieniony = False
        End If
    End Sub

    Public Shared Sub ZapiszDoPlikuTekstowego(nazwaPliku As String, tekst As String())
        Using sw As StreamWriter = New StreamWriter(nazwaPliku)
            For Each wiersz As String In tekst
                sw.WriteLine(wiersz)
            Next
            sw.Close()
        End Using
    End Sub

    Private Sub ZapiszJakoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZapiszJakoToolStripMenuItem.Click
        Dim nazwaPliku As String = OpenFileDialog1.FileName
        If nazwaPliku.Length > 0 Then SaveFileDialog1.FileName = nazwaPliku
        If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
            nazwaPliku = SaveFileDialog1.FileName
            ZapiszDoPlikuTekstowego(nazwaPliku, TextBox1.Lines)
            Dim ostatniSlash As Integer = nazwaPliku.LastIndexOf("\")
            ToolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1)
            TekstZmieniony = False
        End If
    End Sub

    Private Sub CzcionkaToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CzcionkaToolStripMenuItem.Click
        FontDialog1.Font = TextBox1.Font
        If FontDialog1.ShowDialog() = DialogResult.OK Then
            TextBox1.Font = FontDialog1.Font
        End If
    End Sub

    Private Sub TłoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles TłoToolStripMenuItem.Click
        ColorDialog1.Color = TextBox1.BackColor
        If ColorDialog1.ShowDialog() = DialogResult.OK Then
            TextBox1.BackColor = ColorDialog1.Color
        End If
    End Sub

    Private Sub CofnijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CofnijToolStripMenuItem.Click
        TextBox1.Undo()
    End Sub

    Private Sub WytnijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles WytnijToolStripMenuItem.Click
        TextBox1.Cut()
    End Sub

    Private Sub KopiujToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles KopiujToolStripMenuItem.Click
        TextBox1.Copy()
    End Sub

    Private Sub WklejToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles WklejToolStripMenuItem.Click
        TextBox1.Paste()
    End Sub

    Private Sub UsuńToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles UsuńToolStripMenuItem.Click
        TextBox1.SelectedText = ""
    End Sub

    Private Sub ZaznaczWszystkoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZaznaczWszystkoToolStripMenuItem.Click
        TextBox1.SelectAll()
    End Sub
End Class
